'From Squeak3.9 of 7 November 2006 [latest update: #7067] on 23 April 2007 at 2:11:27 pm'!
"Change Set:		VmUpdates-1003-dtl
Date:			23 April 2007
Author:			David T. Lewis

Add oop comparison methods.
  ObjectMemory>>oop:isGreaterThan:
  ObjectMemory>>oop:isGreaterThanOrEqual:
  ObjectMemory>>oop:isLessThan:
  ObjectMemory>>oop:isLessThanOrEqual:

These use #cCoerce:to: to cast their arguments to unsigned usqInt. They are inlined during C translation so performance is not impacted.

Notes: Any explicit C variable declarations in methods will prevent the methods from being inlined. These four new methods, when implemented in ObjectMemory, do the required type casts without disabling inlining. Also, the methods must be implemented here rather than in Object in order for the inlining to work."!


!ObjectMemory methodsFor: 'oop comparison' stamp: 'dtl 4/22/2007 16:01'!
oop: anOop isGreaterThan: otherOop
	"Compare two oop values, treating them as object memory locations.
	Use #cCoerce:to: to ensure comparison of unsigned magnitudes. This
	method will be inlined during C translation."

	^ (self cCoerce: anOop to: #usqInt)
		> (self cCoerce: otherOop to: #usqInt)! !

!ObjectMemory methodsFor: 'oop comparison' stamp: 'dtl 4/22/2007 18:15'!
oop: anOop isGreaterThanOrEqualTo: otherOop
	"Compare two oop values, treating them as object memory locations.
	Use #cCoerce:to: to ensure comparison of unsigned magnitudes. This
	method will be inlined during C translation."

	^ (self cCoerce: anOop to: #usqInt)
		>= (self cCoerce: otherOop to: #usqInt)! !

!ObjectMemory methodsFor: 'oop comparison' stamp: 'dtl 4/22/2007 16:01'!
oop: anOop isLessThan: otherOop
	"Compare two oop values, treating them as object memory locations.
	Use #cCoerce:to: to ensure comparison of unsigned magnitudes. This
	method will be inlined during C translation."

	^ (self cCoerce: anOop to: #usqInt)
		< (self cCoerce: otherOop to: #usqInt)! !

!ObjectMemory methodsFor: 'oop comparison' stamp: 'dtl 4/22/2007 18:15'!
oop: anOop isLessThanOrEqualTo: otherOop
	"Compare two oop values, treating them as object memory locations.
	Use #cCoerce:to: to ensure comparison of unsigned magnitudes. This
	method will be inlined during C translation."

	^ (self cCoerce: anOop to: #usqInt)
		<= (self cCoerce: otherOop to: #usqInt)! !

